(($) => {
	//默认参数
	let defaults = {
		width: "200px",
		height: "35px",
		inpBorderSize: "2px",
		inpBorderColor: "#EEEEEE",
		borderSize: "2px",
		borderColor: "red", //#4e71f2
		placeholder: "搜索",
		borderRadius:"10px",
		static: true,
		paramData: {}
	};
	let settings = null;
	$.fn.extend({
		//初始化
		initSearch(options) {
			if (options != null && options != "") {
				settings = $.extend(defaults, options);
			} else {
				settings = defaults;
			}

			//隐藏原来的输入框
			$(this).css("display", "none");

			//获取原来的输入框的id name
			let inpId = $(this).attr("id");
			let inpName = $(this).attr("name");

			//创建新的输入框
			let input = `<div class="search">
							<div class="search-input">
								<input type="text" id="inp_${inpId}" name="${name}" placeholder="${settings.placeholder}"/>
							</div>
							<div class="search-show div_${inpId}">
								<ul id="ul_${inpId}"></ul>
							</div>
						</div>`;

			//在原来的输入框后面添加新的输入框
			$(this).after(input);

			/* $(`#inp_${inpId}`).css({
				"border-bottom": `${settings.inpBorderSize} solid ${settings.inpborderColor}`,
			}); 

			$(`#inp_${inpId}`).parent().parent().css({
				"min-width": settings.width,
				"border": `${settings.borderSize} solid ${settings.borderColor}`,
			});*/
		
			$(`#inp_${inpId}`).focus(function() {
				$(this).css("border-bottom",
					`${settings.inpBorderSize} solid ${settings.inpBorderColor}`);
					
				$(this).parent().css({
					"border": `${settings.borderSize} solid ${settings.borderColor}`,
					"border-bottom" : "none",
					"border-radius" : `${settings.borderRadius} ${settings.borderRadius} 0px 0px`
				})
				$(this).parent().next().css({
					"display": "block",
					"border": `${settings.borderSize} solid ${settings.borderColor}`,
					"border-top" : "none",
					"border-radius": `0px 0px ${settings.borderRadius} ${settings.borderRadius}`
				});
			});
			
			$(`#inp_${inpId}`).blur(function() {
				$(this).css("border-bottom", "none");
				$(this).parent().css({
					"border": `${settings.borderSize} solid #c4c7ce`,
					"border-radius" : `${settings.borderRadius} ${settings.borderRadius} ${settings.borderRadius} ${settings.borderRadius}`
				})
				
				$(`#ul_${inpId}`).find("li").remove();
				$(this).parent().next().css({
					"display": "none",
					"border": `${settings.borderSize} solid #c4c7ce`,
					"border-top" : "none",
					"border-radius": "0px 0px 0px 0px"
				});
				//$(this).parent().next().css("display", "none");
			});
			
			//注册input 输入监听事件
			$(`#inp_${inpId}`).bind('input propertychange', function() {
				$(`#${inpId}`).val($(`#inp_${inpId}`).val());
				$(`#ul_${inpId}`).find("li").remove();
				if (settings.static) {
					let arr = ["中国工商", "中国工商银行", "中国建设银行", "中国工商局", "中国银行", "中国工人", "中国大集团",
						"中国华为","abcd","efgh","igklmn","opqrst","uvwsyz"
					];
					let val = $(`#inp_${inpId}`).val();
					let len = val.length;

					for (let item of arr) {
						if (item.length >= len && $(`#ul_${inpId}`).find("li").length < 6) {
							let text = item.substring(-1, len);
							let valtext = val.substring(-1, len);
							if (text == valtext) {
								$(`#ul_${inpId}`).append(`
													<li style="cursor: pointer">${item}</li>
												`);
							}
						}
					}
					$(`.div_${inpId}`).css("display", "block");
					//注册li 点击事件
					$(`#ul_${inpId}>li`).mousedown(function(event) {
						let spanText = $(this).html();
						$(`#inp_${inpId}`).val(spanText);
						$(`#${inpId}`).val(spanText);
						$(`.div_${inpId}`).css("display", "none");
						event.stopPropagation(); //  阻止事件冒泡
					});
					$(`#ul_${inpId}>li`).hover(function() {
						$(this).css("color", settings.borderColor);
					}, function() {
						$(this).css("color", "black");
					});
				} else {
					let val = $(`#inp_${inpId}`).val();
					settings.paramData.callback(val);
					L_AJAX.ajaxPack(settings.paramData.param, res => {
						let data = res.data;
						for (let item of data) {
							$(`#ul_${inpId}`).append(`
												<li style="cursor: pointer">${item}</li>
											`);
						}
						$(`.div_${inpId}`).css("display", "block");
						//注册li 点击事件
						$(`#ul_${inpId}>li`).mousedown(function(event) {
							let spanText = $(this).html();
							//console.log(spanText);
							$(`#inp_${inpId}`).val(spanText);
							$(`#${inpId}`).val(spanText);
							$(`.div_${inpId}`).css("display", "none");
							event.stopPropagation(); //  阻止事件冒泡
						});
						$(`#ul_${inpId}>li`).hover(function() {
							$(this).css("color", settings.borderColor);
						}, function() {
							$(this).css("color", "black");
						});
						settings.paramData.succeedCallBack(res);
					}, (res, errInfo) => {
						settings.paramData.errCallBack(res, errInfo);
					})
				}
				
			});
		}
	});
})(jQuery);
