(function(global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() : typeof define === 'function' && define.amd ? define(factory) : (global = global || self, global.Rotation = factory())
}(this, function() {
    var Rotation = function Rotation(id, option) {
        try {
            this.elem = document.getElementById(id);
            this.elem.setAttribute("data", this)
        } catch (error) {
            var error = "未找到id=" + id + "的元素。";
            console.error(error);
            return
        }
        this.doms = Array.prototype.slice.call(this.elem.children);
        this.doms = this.doms.filter(function(item, index) {
            return item.getAttribute("class") !== 'bgBox'
        });
        this.initAngle = (360 / this.doms.length).toFixed(2) - 0;
        this.computAngle = 0;
        this.radius = option.radius || 200;
        this.focusindex = option.focusindex || 1;
        this.focusAngle = this.initAngle * this.focusindex;
        this.speed = option.speed || 1000;
        this.callback = option.callback;
        this.turnAngle = 0;
        this.bgBox = document.getElementsByClassName("bgBox");
        this.activeSlide = option.focusindex || 1;
        this.init()
    };
    Rotation.prototype = {
        isDestroy: false,
        init: function(initType) {
            if (initType) {
                this.computAngle = 0;
                this.doms = Array.prototype.slice.call(this.elem.children);
                this.doms = this.doms.filter(function(item, index) {
                    return item.getAttribute("class") !== 'bgBox'
                });
                this.initAngle = (360 / this.doms.length).toFixed(2) - 0;
                this.focusAngle = this.initAngle * this.focusindex
            };
            var _0 = this;
            this.isDestroy = false;
            if (this.bgBox) {
                this.bgBox[0].style.left = -this.radius + "px";
                this.bgBox[0].style.top = -this.radius + "px";
                this.bgBox[0].style.width = this.radius * 2 + "px";
                this.bgBox[0].style.height = this.radius * 2 + "px"
            };
            this.doms.map(function(val, index) {
                if (initType) {
                    val.style.transform = "rotate(0deg)";
                    val.children[0].style.transform = "rotate(0deg)"
                };
                _0.computAngle = _0.computAngle + _0.initAngle;
                val.setAttribute("actualAngle", _0.computAngle);
                val.setAttribute("actualRotationAngle", 0);
                val.setAttribute("index", index);
                val.rotation = _0;
                val.addEventListener("click", _0.selectedMod);
                val.style.transition = "all " + (_0.speed / 1000) + "s";
                val.children[0].style.transition = "all " + (_0.speed / 1000) + "s";
                if (_0.focusindex === index + 1) {
                    val.className += ' rotation-active'
                };
                var valH = val.offsetHeight - 0,
                    valW = val.offsetWidth - 0;
                if (_0.computAngle > 0 && _0.computAngle < 90) {
                    var sideLength = _0.sideLength(_0.radius, _0.computAngle);
                    val.style.top = -sideLength.oppositeSide - valH / 2 + "px";
                    val.style.left = sideLength.adjacentSide - valW / 2 + "px";
                    var origin = "-" + (sideLength.adjacentSide - valW / 2) + "px " + (sideLength.oppositeSide + valH / 2) + "px";
                    val.style.transformOrigin = origin
                } else if (_0.computAngle > 89 && _0.computAngle < 180) {
                    var sideLength = _0.sideLength(_0.radius, _0.computAngle - 90);
                    val.style.top = sideLength.adjacentSide - valH / 2 + "px";
                    val.style.left = sideLength.oppositeSide - valW / 2 + "px";
                    var origin = "-" + (sideLength.oppositeSide - valW / 2) + "px " + (valH / 2 - sideLength.adjacentSide) + "px";
                    val.style.transformOrigin = origin
                } else if (_0.computAngle > 179 && _0.computAngle < 270) {
                    var sideLength = _0.sideLength(_0.radius, _0.computAngle - 180);
                    val.style.top = sideLength.oppositeSide - valH / 2 + "px";
                    val.style.left = -sideLength.adjacentSide - valW / 2 + "px";
                    var origin = (sideLength.adjacentSide + valW / 2) + "px " + (valH / 2 - sideLength.oppositeSide) + "px";
                    val.style.transformOrigin = origin
                } else {
                    var sideLength = _0.sideLength(_0.radius, _0.computAngle - 270);
                    val.style.top = -sideLength.adjacentSide - valH / 2 + "px";
                    val.style.left = -sideLength.oppositeSide - valW / 2 + "px";
                    var origin = (sideLength.oppositeSide + valW / 2) + "px " + (sideLength.adjacentSide + valH / 2) + "px";
                    val.style.transformOrigin = origin
                }
            })
        },
        selectedMod: function(index, callback) {
            var thisIndex = null;
            if (!isNaN(index)) {
                thisIndex = index
            } else {
                thisIndex = this.getAttribute("index") - 0
            };
            if (this.rotation) {
                this.rotation.activeSlide = thisIndex + 1;
                this.rotation.activationFun(this, thisIndex);
                this.rotation.callback(this, thisIndex + 1)
            } else {
                if (this.isDestroy) {
                    return false
                }
                this.activeSlide = thisIndex;
                this.activationFun(this.doms[thisIndex - 1], thisIndex - 1);
                if (callback) {
                    this.callback(this.doms[thisIndex - 1], thisIndex)
                }
            }
        },
        sideLength: function(long, angle) {
            var radian = 2 * Math.PI / 360 * angle;
            return {
                adjacentSide: (Math.sin(radian) * long).toFixed(2) - 0,
                oppositeSide: (Math.cos(radian) * long).toFixed(2) - 0
            }
        },
        activationFun: function(ele, index) {
            _0 = this;
            if (this.focusindex === index + 1) {
                return false
            };
            this.focusindex = index + 1;
            var actualAngle = ele.getAttribute("actualAngle") - 0,
                focusAngle = this.focusAngle,
                rotationAngle = 0;
            if (Math.abs(actualAngle - focusAngle) <= 180) {
                rotationAngle = -(actualAngle - focusAngle)
            } else if (actualAngle < focusAngle - 180) {
                rotationAngle = -(360 - focusAngle + actualAngle)
            } else if (actualAngle > focusAngle + 180) {
                rotationAngle = 360 - actualAngle + focusAngle
            } else if (focusAngle - 180 < actualAngle && actualAngle < focusAngle) {
                rotationAngle = focusAngle - actualAngle
            };
            _0.turnAngle = rotationAngle;
            this.doms.map(function(val, num) {
                var valActualAngle = val.getAttribute("actualAngle") - 0;
                val.setAttribute("actualAngle", _0.calcAngle(valActualAngle + _0.turnAngle));
                var actualRotationAngle = val.getAttribute("actualRotationAngle") - 0;
                val.style.transform = "rotate(" + (actualRotationAngle + _0.turnAngle) + "deg)";
                val.setAttribute("actualRotationAngle", actualRotationAngle + _0.turnAngle);
                if (num === _0.focusindex - 1) {
                    val.classList.add("rotation-active")
                } else {
                    val.classList.remove("rotation-active")
                }
                val.children[0].style.transform = "rotate(" + -(actualRotationAngle + _0.turnAngle) + "deg)"
            })
        },
        calcAngle: function(ang) {
            if (ang > 360) {
                return ang - 360
            } else if (ang < 0) {
                return 360 + ang
            } else {
                return ang
            }
        },
        hasClassFun: function(element, cls) {
            return (' ' + element.className + ' ').indexOf(' ' + cls + ' ') > -1
        },
        destroy: function(clear) {
            var _1 = this;
            this.isDestroy = true;
            this.doms.map(function(ele, index) {
                ele.removeEventListener("click", _1.selectedMod)
            });
            if (!(clear === false)) {
                for (var k in this) {
                    delete this[k]
                }
            }
        }
    };
    return Rotation
}))