/*wolcott original*/
/*fixed table th and random left column*/

function table_fixer(ele,tableHeight,fixedLeftLength){
	if(fixedLeftLength==undefined){
		fixedLeftLength = 0;
	}
    var $ele = $(ele);
    var thisId = (Math.random() + "").replace(/\./g, "");
    var colLength = $ele.find("th").length; //eleTable's column length
    var visLength = colLength - fixedLeftLength;//eleTable's visible column length
    var colWidth = $ele.parent().width()/visLength;//eleTable's visible column width
    $ele.width(colLength*colWidth);
    $ele.find("th").each(function(){
        $(this).width(colWidth);
    })

    //create a frame for all tables
    $ele.wrap('<div class="table_'+thisId+'"></div>');
    $('.table_'+thisId).css({
        "width":"100%",
        "height":tableHeight,
        "float":"left",
        "position":"relative",
        "border":"1px solid #e7e7e7",
        "border-radius":"3px",
        "overflow":"hidden"
    })
    $ele.wrap('<div class="scroll_'+thisId+'"></div>');
    $('.scroll_'+thisId).css({
        "width":"100%",
        "height":tableHeight,
        "float":"left",
        "position":"relative",
        "overflow":"auto"
    })

    if(fixedLeftLength != 0){
		//create left fixed columns
		$('.table_'+thisId).append('<div class="left_scroll_'+thisId+'"></div>');
		$('.left_scroll_'+thisId).css({
			"width":"auto",
			"height":tableHeight,
			"position":"absolute",
			"box-shadow":"1px 0 0 rgba(0,0,0,0.1)",
			"top":"0",
			"left":"0",
			"overflow":"auto"
		})
		var leftFixedHtml = $ele.clone().addClass("fixed_left"+thisId);
		$('.left_scroll_'+thisId).append(leftFixedHtml);
		$('.fixed_left'+thisId).css({
			"float":"left"
		});
		for(var i=fixedLeftLength;i<colLength;i++){
			$('.fixed_left'+thisId+' th').eq(fixedLeftLength).remove();
			$('.fixed_left'+thisId+' tr').each(function() {
				$(this).children("td").eq(fixedLeftLength).remove();
			});
			$('.fixed_left'+thisId).width(colWidth*fixedLeftLength);
		}
		$('.fixed_left'+thisId).find("td").each(function(index){
			$(this).height($ele.find("td").height())
		})
	
		//create fixed left top area
		var leftTopFixedHtml = $ele.clone().addClass("fixed_left_top"+thisId);
		$('.table_'+thisId).append(leftTopFixedHtml);
		$('.fixed_left_top'+thisId).css({
			"position":"absolute",
			"box-shadow":"1px 0 0 rgba(0,0,0,0.1)",
			"z-index":"222"
		});
		$('.fixed_left_top'+thisId+' tr').each(function(index){
			if(index != 0){
				$(this).remove();
			}
		})
		for(var i=fixedLeftLength;i<colLength;i++){
			$('.fixed_left_top'+thisId+' th').eq(fixedLeftLength).remove();
			$('.fixed_left_top'+thisId).width(colWidth*fixedLeftLength);
		}
	}
	
	//create fixed top row
    var topFixedHtml = $ele.clone().addClass("fixed_top"+thisId);
    $('.table_'+thisId).append(topFixedHtml);
    $('.fixed_top'+thisId).css({
        "position":"absolute"
    });
    $('.fixed_top'+thisId+' tr').each(function(index){
        if(index != 0){
            $(this).remove();
        }
    })

    //scroll controls
    $('.scroll_'+thisId).scroll(function(event){
        var scrollTopVal = $('.scroll_'+thisId).scrollTop();
        var scrollLeftVal = $('.scroll_'+thisId).scrollLeft();
        $('.left_scroll_'+thisId).scrollTop(scrollTopVal);
        $('.fixed_top'+thisId).css("left",-scrollLeftVal);
    })
    $('.left_scroll_'+thisId).scroll(function(){
        var scrollVal = $('.left_scroll_'+thisId).scrollTop();
        $('.scroll_'+thisId).scrollTop(scrollVal);
    })
}