﻿(function (root, factory) {
    "use strict";
    if (typeof define === "function" && define.amd) {
        define(["jquery"], factory);
    } else if (typeof exports === "object") {
        module.exports = factory(require("jquery"));
    } else {
        factory(root.jQuery);
    }
}(this, function init($, undefined) {
    if ($.zhoujl === undefined) {
        $.zhoujl = {};
    }

    //序号50+表名称180=左边总偏移230 
    var offsetLeft = 230;
    $.zhoujl.table = function (width, height, tdWidth) {
        $("#scroll-table").css("width", (1 + width) + "px");
        $("#table-content-container-mark").css("width", width + "px");
        $(".table-content-container").css("width", (width + 20) + "px");
        $(".table-body-container").css("width", (width - offsetLeft) + "px");
        $(".table-title-scroll").css("width", (width - offsetLeft) + "px");

        var scrollContainerWidth = $(".table-title-scroll-container div").length * tdWidth;
        if (width > scrollContainerWidth + offsetLeft) {
            $(".table-title-scroll-container").css("width", (width - offsetLeft) + "px");
            $(".table-body-container table").css("width", (width - offsetLeft) + "px");
            $(".table-title-scroll").css("overflow-x", "none");
            $(".table-body-container").css("overflow-x", "none");
            $("#table-content-container-mark").css("marginTop", "0");
            var gridWidth = (width - offsetLeft) / $(".table-title-scroll-container div").length;
            $(".table-title-scroll-container div").css("width", gridWidth + "px");
            $(".table-body-container td").css("width", gridWidth + "px");
            createScroll(width - offsetLeft, width);
        } else {
            $(".table-title-scroll-container").css("width", scrollContainerWidth + "px");
            $(".table-body-container table").css("width", scrollContainerWidth + "px");
            $(".table-title-scroll").css("overflow-x", "auto");
            $(".table-body-container").css("overflow-x", "auto");
            $("#table-content-container-mark").css("marginTop", "-17px");
            $(".table-title-scroll-container div").css("width", tdWidth + "px");
            $(".table-body-container td").css("width", tdWidth + "px");
            createScroll(scrollContainerWidth, width);
        }

        var totalHeight = $("#table-body-container").height() + $(".table-title-container").height();
        var offset = 0;
        if (width > scrollContainerWidth + offsetLeft) {
            offset = 17;
        }
        if (height > totalHeight) {
            $(".table-content-container").css("overflow-y", "none");
            $("#table-content-container-mark").css("height", ($("#table-body-container").height() + offset) + "px");
            $(".table-content-container").css("height", ($("#table-body-container").height() + offset) + "px");
        } else {
            var contentHeight = height - $(".table-title-container").height();
            $(".table-content-container").css("overflow-y", "auto");
            $("#table-content-container-mark").css("height", (contentHeight + offset) + "px");
            $(".table-content-container").css("height", contentHeight + "px");
        }
    }

    //创建底部滑动条
    function createScroll(scrollWidth, totalWidth) {
        $(".table-scroll-mark").remove();
        $("#scroll-table").append("<div class='table-scroll-mark' style='width: " + totalWidth + "px;'>" +
            "<div class='table-scroll' style = 'width:" + (totalWidth - offsetLeft) + "px;'>" +
            "<div style='width: " + scrollWidth + "px; height: 1px'></div>" +
            "</div ></div >")

        $(".table-scroll").scroll(function () {
            $(".table-title-scroll").scrollTop(this.scrollTop);
            $(".table-title-scroll").scrollLeft(this.scrollLeft);
            $(".table-body-container").scrollTop(this.scrollTop);
            $(".table-body-container").scrollLeft(this.scrollLeft);
        });
    }
}));

