/*
*   add by lero
*   2018.7.11
*   活动详情
* */

// 滚动插件
;(function (global) {
    $.fn.scrollTo = function (options) {
        var defaults = {
            toT: 0,    //滚动目标位置
            durTime: 300,  //过渡动画时间
            delay: 60,     //定时器时间
            callback: null   //回调函数
        };
        var opts = $.extend(defaults, options),
            timer = null,
            _this = this,
            curTop = _this.scrollTop(),//滚动条当前的位置
            subTop = opts.toT - curTop,    //滚动条目标位置和当前位置的差值
            index = 0,
            dur = Math.round(opts.durTime / opts.delay),
            smoothScroll = function (t) {
                index++;
                var per = Math.round(subTop / dur);
                if (index >= dur) {
                    _this.scrollTop(t);
                    window.clearInterval(timer);
                    if (opts.callback && typeof opts.callback === 'function') {
                        opts.callback();
                    }
                    return;
                } else {
                    _this.scrollTop(curTop + index * per);
                }
            };

        timer = window.setInterval(function () {
            smoothScroll(opts.toT);
        }, opts.delay);


        return _this;
    };
}(window));

// 分页/回到顶部 功能
;(function ($) {

    'use strict';

    var opt = {
        // 起始位置，滚动条位置大于这个位置的时候显示
        startPos: 100,
        // 步进高度，每滚动这个高度加减分页数据加减 1
        stepHeight:100,
        // 是否一直显示
        always: false,
        // 分页图标变成回到顶部图标的时间
        time: 1000,
        // 必传，总页数
        total: 10
    };

    var htList = [],
        // 滚动距离
        posValue = 0;
    // 翻页
    var setCur = function (num) {
        $(opt.element).find('.ac-page-cur').text(num);
    };

    // 插件初始化
    var init = function (element, option) {
        opt = $.extend({}, opt, option);
        opt.element = element;
        $(element).hide();
        opt.always && $(element).show();
        setCur(1);
        $(element).find('.ac-page-total').text(opt.total);
        var num = opt.total;
        while (num--){
            htList.unshift(opt.startPos + opt.stepHeight * num)
        }

        console.log(htList);
    };

    // 一段时间后，执行方法
    var delayFuc = function (callback) {
      setTimeout(function () {
          callback && callback()
      }, opt.time);
    };

    // 页面滚动时调用函数
    var onScroll = function () {
        var posValue =  $(window).scrollTop();
        if(!opt.always && posValue < opt.startPos){
            setCur(1);
            $(opt.element).hide();
            return false;
        } else if(!opt.always && posValue < htList[1]) {
            setCur(1);
            $(opt.element).show();
        } else {
            var index = 0;
            for(; index < htList.length; ++index){
                if(posValue < htList[index]){
                    break;
                }
            }
            setCur(index || 1);
            $(opt.element).show();
            $(opt.element).find('.ac-page-nav').show();
            $(opt.element).find('.ac-page-top').hide();
        }
        // 滚动停止时
        delayFuc(function () {
           if(posValue === $(window).scrollTop()){
               if(posValue < htList[1]){
                   opt.always || $(opt.element).hide();
               } else {
                   $(opt.element).find('.ac-page-nav').hide();
                   $(opt.element).find('.ac-page-top').show().css('opacity', '1');
               }
           }
        });

    };

    // 添加事件
    var addEvent = function(element){
        $(element).on('click.top', function (event) {
            $("body,html").scrollTo({toT: 0});
        });
        $(document).on('scroll', function (event) {
            onScroll(opt.always)
        });
    };

    opt.updateTotal = function(total){
        opt.total = total;
        $(opt.element).find('.ac-page-total').text(total);
    };
    opt.updateCul = function(cur){
        $(opt.element).find('.ac-page-cur').text(cur);
    };

    $.fn.pageination = function (option) {
        var that = this;
        init(that, option);
        addEvent(that);
        return opt;
    };
}($));


// 业务代码
;(function () {

    var page_instance = $('#J-page').pageination({
        always:false,
        startPos: 300,
        // 步进高度，每滚动这个高度加减分页数据加减 1
        stepHeight: 700,
        // 总页数
        total: 5
    });

}());