
let css = '.tb_select{position: fixed;bottom: 0;left: 0;right: 0;top: 0;background: rgba(0,0,0,0.4);z-index: 999;}.tb_select_bg{width: 100%;height: 100%;}.tb_select_box{position: absolute;left: 0;bottom: 0;width: 100%;height: auto;background: #ffffff;z-index: 10;}.select_top{position: absolute;left: 0;top: 0;width: 100%;height: 38px;z-index: 10;background: #ffffff;display: flex;justify-content: space-between;align-items: center;}.select_confirm,.select_cancel{width: 15%;height: 100%;display: flex;justify-content: center;align-items: center;color: #333333;font-size: 14px;}.select_cancel{color: #999999;}.select_title{width: 60%;display: flex;justify-content: center;align-items: center;color: #666666;font-size: 14px;}.select_end{width: 100%;height: auto;max-height:60vh;overflow: hidden;overflow-y: scroll;padding: 38px 10px 0;box-sizing: border-box;}.select_item{width: 100%;height: 38px;font-size: 14px;color: #666666;display: flex;justify-content: space-between;align-items: center;}';
document.write('<style type="text/css">'+css+'</style>');
(function (){
    let icon = {
        check:'<svg t="1623396324419" class="icon icon-check" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="7659" width="20" height="20"><path d="M511.625 1020.911c-280.824 0-509.307-228.482-509.307-509.306S230.801 2.298 511.625 2.298s509.307 228.483 509.307 509.307-228.482 509.306-509.307 509.306z m0-970.107c-254.085 0-460.801 206.716-460.801 460.801S257.54 972.407 511.625 972.407s460.801-206.718 460.801-460.802-206.716-460.8-460.8-460.8z" p-id="7660" fill="#999999"></path></svg>',
        checked:'<svg t="1623396434452" class="icon icon-checked" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="8337" width="20" height="20"><path d="M512 0A512 512 0 1 0 1024 512 512 512 0 0 0 512 0z m275.721481 371.041975L458.145185 689.366914a25.283951 25.283951 0 0 1-34.891852 0L236.531358 515.160494a25.283951 25.283951 0 0 1 34.512593-36.914568l169.276049 158.024691 312.25679-301.637531a25.283951 25.283951 0 0 1 35.144691 36.408889z" fill="#EC5151" p-id="8338" data-spm-anchor-id="a313x.7781069.0.i10" class="selected"></path><path d="M752.57679 334.633086l-312.25679 301.637531-169.276049-158.151111a25.283951 25.283951 0 0 0-34.512593 36.914568l186.848395 174.585679a25.283951 25.283951 0 0 0 34.891852 0l329.449876-318.577778a25.283951 25.283951 0 0 0-35.144691-36.408889z" fill="#FFFFFF" p-id="8339"></path></svg>'
    }
    let pickerSelect = function (options){
       let _this = this;
       _this.options = $.extend({
           el:'', /*class或者id*/
           placeholder:'请选择', /*提示内容*/
           val:'',
           list:[], /*数据列表*/
           callBack:null, /*返回*/
           type:'radio' /*选择类型 radio|checkbox*/
       },options);
        _this.init();
    }
    pickerSelect.prototype = {
        init:function (){
            let _this = this;
            $('.'+_this.options.el).append("<input class='ta_select_place tb_"+_this.options.el+"' placeholder='"+_this.options.placeholder+"' readonly />");
			for(key in _this.options.list){
				if(_this.options.list[key].id == _this.options.val){
					$(".tb_"+_this.options.el).val(_this.options.list[key].name)
				}
			}
        },
        load:function (options){
            let _this = this;
            for(key in options){
                for(item in _this.options){
                    if(key == item){
                        _this.options[item] = options[key];
                    }
                }
            }

        },
        click:function (options){
            let _this = this;
            for(key in options){
                for(item in _this.options){
                    if(key == item){
                        _this.options[item] = options[key];
                    }
                }
            }
            let returnVal = '';
            let returnValName = '';
            _this.selectHtml();
            $(document).off('click').on('click','.picker_select_btn',function (){
                let thisBtn = $(this);
                let type = thisBtn.attr('type');
                if(type){
					
					let arr = [],arr1 = []
					if(type == 'confirm'){
						$(document).find("div.select_item").each(function(){
							
							if($(this).hasClass("active")){
								arr.push($(this).attr('data-id'));
								arr1.push($(this).attr('data-name'))
								returnVal = arr.join(',');
								returnValName = arr1.join(' ');
							}
							// console.log(returnVal,returnValName)
						})
						
						$(document).find(".tb_"+_this.options.el).val(returnValName);
						options.callBack != null? options.callBack({
						    val:returnVal,
						    name:returnValName
						}) : "";
					}
					
					$(document).find(".tb_select").remove();
				}else{
					
					if(_this.options.type == 'checkbox'){
						thisBtn.find("svg").remove();
						if(thisBtn.hasClass("active")){
							thisBtn.removeClass("active");
							thisBtn.append(icon.check)
						}else{
							thisBtn.addClass("active");
							thisBtn.append(icon.checked)
						}
						
					}else{
						$(document).find("div.select_item").removeClass("active");
						thisBtn.addClass("active");
						$(document).find("div.select_item").find("svg").remove();
						$(document).find("div.select_item").append(icon.check);
						$(document).find("div.select_item").eq(thisBtn.index()).find("svg").remove();
						$(document).find("div.select_item").eq(thisBtn.index()).append(icon.checked);
					}
					
					
				}
				
            })
        },
        selectHtml:function (){
            let _this = this;
            let tb_select = document.createElement("div");
            tb_select.className = 'tb_select';
            let tb_select_bg = document.createElement("div");
            tb_select_bg.className = 'tb_select_bg picker_select_btn';
            tb_select_bg.setAttribute("type",'bg');
            tb_select.appendChild(tb_select_bg);
            let tb_select_box = document.createElement("div");
            tb_select_box.className = 'tb_select_box';
            tb_select.appendChild(tb_select_box);
            let select_top = document.createElement("div");
            select_top.className = 'select_top';
            tb_select_box.appendChild(select_top);
            let select_cancel = document.createElement("div");
            select_cancel.className = 'select_cancel picker_select_btn';
            select_cancel.setAttribute("type",'cancel');
            select_cancel.innerHTML = "取消";
            let select_confirm = document.createElement("div");
            select_confirm.className = 'select_confirm picker_select_btn';
            select_confirm.setAttribute("type",'confirm');
            select_confirm.innerHTML = "确定";
            let select_title = document.createElement("div");
            select_title.className = 'select_title';
            select_title.innerHTML = _this.options.placeholder;
            select_top.appendChild(select_cancel);
            select_top.appendChild(select_title);
            select_top.appendChild(select_confirm);
            let select_end = document.createElement("div");
            select_end.className = 'select_end';
            tb_select_box.appendChild(select_end);
            let select_item = "";
            for(i in _this.options.list){
                select_item =  document.createElement("div");
                select_item.className = 'select_item picker_select_btn';
                select_item.setAttribute("data-id",_this.options.list[i].id);
                select_item.setAttribute("data-name",_this.options.list[i].name);
				let arr = _this.options.val.split(',');
				select_item.innerHTML = _this.options.list[i].name+icon.check;
				for(key in arr){
					if(_this.options.list[i].id == arr[key]){
						select_item.className += " active";
						select_item.innerHTML = _this.options.list[i].name+icon.checked;
					}
				}
                select_end.appendChild(select_item);
            }

            document.body.appendChild(tb_select);

        }

   }
   window.pickerSelect = pickerSelect;
}())