
function commonBarOption() {
	var option = {
    title: {
        // text: "正负发票",
        subtext: "纯属虚构"
    },
    tooltip: {
        // trigger: "axis"
    },
    legend: {
        data: ["金额", "税额"]
    },
    toolbox: {
        show: true,
        feature: {
            mark: {
                show: true
            },
            dataView: {
                show: true,
                readOnly: true
            },
            magicType: {
                show: false,
                type: ["line", "bar"]
            },
            restore: {
                show: true
            },
            saveAsImage: {
                show: true
            }
        }
    },
    calculable: true,
    xAxis: [
        {
          type: "category",
          // data: ["负数发票", "正数发票"]
        }
    ],
    yAxis: [
        {
            type: "value"
        }
    ],
    series: [
        {
            name: "金额",
            type: "bar",
        },
        {
            name: "税额",
            type: "bar",
        },
    ]
	};
	return option;
}
// 正负发票
function r_zffp_bar(data) {
	var option = commonBarOption();
	option.title.text = '正负\n发票';
	option.xAxis[0].data = ["负数发票", "正数发票"];
	option.series[0].data = data[0];
	option.series[1].data = data[1];
	return option;
}
// 正数发票
function l_zsfp_bar(data) {
	var option = commonBarOption();
	option.title.text = '正数发票';
	option.xAxis[0].data = ["未开票", "已开票", "已作废"];
	option.series[0].data = data[0];
	option.series[1].data = data[1];
	return option;
}
window.ChartsOption = {
	r_zffp_bar: r_zffp_bar,
	l_zsfp_bar: l_zsfp_bar,
}