$(function() {

	var rates = [0.00, 0.06, 0.10];
// var rates = [0.00, 0.06, 0.10, 0.11,0.12,0.13,0.14];
var group = 2;
var rows = 3;
var cols = 3;
var randomMax = 100000;
var head_title_len = 15; 
var move_distance = 5;
if (window.matchMedia) {
  var mediaQueryList = window.matchMedia('print');
  // 监听打印完成操作
  mediaQueryList.addListener(function(mql) {
      if (mql.matches) {
          console.log('Functionality to run before printing.');
      } else {
          console.log('Functionality to run after printing');
          $('#btn-group').toggle();
          $('.dg .close-button').toggle();
          $('#tab-chart').show();
          chartOption.resetChart();

      }
  });
}


$('body').on('click', '#options li', function(e) {
	let _self = this;
	let _text = $(this).text();
	let _arrText = ['正负发票','税率','税额','金额'];
	tipOption.indicatorAnimate(_self);
	
})
$('body').on('keydown keyup', '.head-title', function() {
	let length = $(this).text().length;
	if (length > head_title_len) {
		let tip = {
			title: {
				text: '<b>提示</b>',
			},
			content: {
				text: '这里只是一个辅助功能，以便自定义打印。<br>内容过长会导致布局错乱，控制权交给你了。',
			}
		}
		$.alertTip(tip);
	} 
	if (length == 0) {
		$(this).text('...');
	}

})
$('body').on('keydown keyup', '#detail-1', function() {
	let length = $(this).text().length;
	$('#detail-length-tip').text(length);
})
$('body').on('click', '.common-head>.btns>.up-move', function() {
	let selector = $(this).parent().parent();
	let marginTop = selector.css("margin-top");
	let dif = 0;
	datGUI_options.moveSpeed ? (dif = datGUI_options.moveSpeed) : move_distance;
	selector.css("margin-top",(parseInt(marginTop) - dif + 'px'));
})
$('body').on('click', '.common-head>.btns>.down-move', function() {
	let selector = $(this).parent().parent();
	let marginTop = selector.css("margin-top");
	let dif = 0;
	datGUI_options.moveSpeed ? (dif = datGUI_options.moveSpeed) : move_distance;
	selector.css("margin-top",(parseInt(marginTop) + dif + 'px'));
})
$('body').on('click', '.common-head>.btns>.distance-reset', function() {
	console.log($(this))
	let selector = $(this).parent().parent();
	selector.css("margin-top",'0');
})
$('body').on('click', '.common-head>.btns>.hide-title', function() {
	$('#btn-showtitle>.badge').text(Number($('#btn-showtitle>.badge').text()) + 1);
	$(this).parent().parent().hide('slow');

})
$('body').on('click', '.common-head>.btns>.down-text, .common-head>.btns>.up-text', function() {
	$(this).toggleClass('glyphicon-chevron-down down-text up-text');
	$(this).parent().parent().next().slideToggle('slow');

})


$('body').on('click', '#btn-print', function() {
	$('#btn-group').toggle();
	$('.dg .close-button').toggle();
	var chart1 = echarts.init(document.getElementById('chart1'));
	var chart2 = echarts.init(document.getElementById('chart2'));
	var img1 = new Image();
	var img2 = new Image();
	var imgSrc1 = chart1.getDataURL();
	var imgSrc2 = chart2.getDataURL();
	// 渲染到图表上面，遮住图表
	img1.src = imgSrc1;
	img2.src = imgSrc2;
	chartOption.resetChartLatout();
	$('#chart1').append(img1);
	$('#chart2').append(img2);
	// 这里需要适当的延时
	setTimeout(() => {
		window.print();
	},500);
});
$('body').on('click', '#btn-chart', function() {
		chartOption.resetChart();
});
$('body').on('click', '#btn-randomData', function() {
	
	randomData.redrawCenterLayout();
	randomData.sumAll();
	randomData.formatData();
	chartOption.resetChart();
	
});
$('body').on('click', '#btn-sum', function() {
	randomData.sumAll();
});
$('body').on('click', '#btn-format', function() {
	randomData.formatData();
});
$('body').on('click', '#btn-backdrop', function() {


});
$('body').on('click', '#btn-showtitle', function() {
	$('#btn-showtitle>.badge').text(0);
  $('.common-head').show();
});

/**
 * [鼠标在单元格上方时，显示提示框]
 * 2018-7-19在这里弃用hover,因为此事件在JQ新版本中不支持，还是采用mousemove
 */
$('body').on('mousemove', 'td,th', function(e) {
	var parentID = $(this).parent()[0].id;
	if (parentID) {
		var body_width = $('body').outerWidth();
		var body_height = $('body').outerHeight();
		var tip_board_width = $('#tip-board').outerWidth();
		var tip_board_height = $('#tip-board').outerHeight();
    	var x = e.pageX;
    	var y = e.pageY;
    	var dif = 2
	    if ((body_width - x) < tip_board_width) {
				_left = x - tip_board_width - dif;
			} else {
				_left = x + dif;
			}
			if ((body_height - y) < tip_board_height) {
				_top = y - tip_board_height - dif;
			} else {
				_top = y + dif;
			}
			$('#tip-board').css({
	      "top" : _top + "px",
	      "left" : _left  + "px"
	    });
	    
	    // tipOption.changeXYIndicator(e);
	    tipOption.setTipBoard(this, tipOption.judgeXY(this));
	    
	} else {
			// tipOption.resetXYIndicator();
			$('#tip-board').hide();
	}
}).on('mouseout', 'td,th', function(e) {
	$('#tip-board').hide();	
});


var tipOption = {
	judgeXY: function(_self) {
		var parentID = $(_self).parent()[0].id;
		var sign = parentID.split('-');
		var cellIndex = $(_self)[0].cellIndex;
			var tip = []
			if (sign[0] == 'all') {
				tip.push('正负发票');
			} else if (sign[0] == 'f') {
				tip.push('负数发票');
			} else if (sign[0] == 'z') {
				tip.push('正数发票');
			} else {
				tip.push('标志位有误');
			}
			if (sign[1] == 'all') {
				tip.push('合计');
			} else if (sign[1] == '0') {
				tip.push('未开票');
			} else if (sign[1] == '1') {
				tip.push('已开票');
			} else if (sign[1] == '2') {
				tip.push('已作废');
			} else {
				tip.push('标志位有误');
			}
			sign[2] == 'all' ? tip.push('合计') : tip.push(Number(sign[2]).toFixed(2));
			cellIndex == 0 ? tip.push('金额') : (cellIndex == 1 ? tip.push('税额') : tip.push('商品'));
			return tip;
	},
	setTipBoard: function(_self, arr) {
		$('#cell-v').text($(_self).text());
    $('#cell-r').text(arr[0] + '-' + arr[1]);
    $('#cell-c').text(arr[2] + '-' + arr[3]);
    $('#tip-board').show();
	},
	changeXYIndicator: function(e) {
		var x = e.pageX;
		var y = e.pageY;
		var dif = 5;
		var xIndicatorLength = $('#container')[0].offsetWidth;
		var yIndicatorLength = $('#content-view1 table')[0].offsetHeight;
		$('#x-indicator').css({
			top: `${y-dif}px`,
			width: `${xIndicatorLength}px`
		});
		$('#y-indicator').css({
			left: `${x-dif}px`,
			height: `${yIndicatorLength}px`
		});
	},
	resetXYIndicator: function() {
		$('#x-indicator').css({
			top: 0,
			width: '300px'
		});
		$('#y-indicator').css({
			left: 0,
			height: '300px'
		});
	},
	indicatorAnimate: function(_self) {
		$(_self).css("border-bottom", "none");
		$(_self).siblings().css("border-bottom", "none");
		let $this = $(_self)[0];
		let _top = $this.offsetTop;
		let _height = $this.offsetHeight;
		let _left = $this.offsetLeft;
		let _width = $(_self).width();
		$('#x-indicator').css({
			"top": `${_top + _height}px`,
			"left": `${_left}px`,
			"display": "inline-block",
			"width": 0,
		});
		$('#x-indicator').animate({
			width: `${_width}px`,
		}, function() {
			$('#x-indicator').hide();
			$(_self).css("border-bottom", "2px solid red");
		})
	},
};

var chartOption = {

	resetChartLatout: function() {
		let selector = '#tab-chart>#chart';
		$(selector).empty();
		var div = `<div class="chart-child" id="chart1"></div>
								<div class="chart-child" id="chart2"></div>`;
		$(selector).append(div);
	},
	resetChart: function() {
		chartOption.resetChartLatout();
		let chart1 = echarts.init(document.getElementById('chart1'));
		let chart2 = echarts.init(document.getElementById('chart2'));
		chart1.setOption(ChartsOption.r_zffp_bar(randomData.getZF_PriceAndTaxSum()));
		chart2.setOption(ChartsOption.l_zsfp_bar(randomData.getZS_PriceAndTaxSum()));
	},

};

var randomData = {
	redrawCenterLayout: function() {
		$('#content-view2').empty();
		let rateNum = this.setRateRow(rates);
		for (var i = 0; i < rateNum; i++) {
			let cell = [];
			let sum = [];
			for (var j = 0; j < group; j++) {
				let row_col_data;
				j == 0 && (row_col_data = this.setCellData(rows, cols, '-'));
				j == 1 && (row_col_data = this.setCellData(rows, cols, '+'));
				let colSum = this.sumCol(row_col_data);
				cell.push(row_col_data);
				sum.push(colSum);
			}
			sum.push(this.sumColTotal(sum[0], sum[1]));
			let table_data = {
				rate: rates[i],
				cell: cell,
				sum: sum,
			};
			let div = '';
			div = this.setLayout(table_data);
			$('#content-view2').append(div);
		}			
	},
	// 设置税率个数
	setRateRow: function(arr) {
		let len = arr.length;
		return Math.ceil(Math.random() * len);
	},
	// 设置单元格随机数据
	setCellData: function(row, col, sign) {
		let row_col = [];
		for (var i = 0; i < row; i++) {
			let a_row = [];
			let d;
			for (var j = 0; j < col; j++) {
				d = (Math.random() * randomMax).toFixed(2);
				a_row.push(sign + d);
			}
			row_col.push(a_row);
		}
		return row_col;
	},
	// 按行求和
	sumRow: function(arr) {
		let rowSum = [];
		arr.forEach(function(context, i) {
			let sum = 0;
			arr[i].forEach(function(item, index) {
				sum += Number(item);
			})
			rowSum.push(sum.toFixed(2));
		})
		return rowSum;
	},
	// 按列求和
	sumCol: function(arr) {
		let colSum = [];
		let row = arr.length;
		let col = arr[0].length;
		for(var i = 0; i < col; i++) {
			let sum = 0;
			for(var j = 0; j < row; j++) {
				sum += Number(arr[j][i]);
			}
			colSum.push(sum.toFixed(2));
		}
		return colSum;
	},
	// 按行求总和
	sumColTotal: function(arr1, arr2) {
		var sum = [];
		arr1.forEach(function(item, index) {
			let d = Number(item) + Number(arr2[index]);
			sum.push(d.toFixed(2));
		})
		return sum;
	},
	// 右侧汇总求和
	sumAll: function() {
		var $selector = $('#content-view2 div table');
		var arr = Array(28).join('0').split('');
		var row = 9;
		var col = 3;
		for (var i = 0; i < $selector.length; i++) {
			for (var j = 0; j < row; j++) {
				for (var k = 0; k < col; k++) {
					var cell = `tr:eq(${2 + j}) td:eq(${k})`;
					if (j % 4 == 0 )  cell = `tr:eq(${2 + j}) th:eq(${k})`;
					var text = $($selector[i]).find(cell).text();
					arr[j * 3 + k] = Number(arr[j * 3 + k]) + Number(String(text).replace(/,/g, ''));
					if (i == $selector.length - 1) {
						var sumCell = `tr:eq(${2 + j}) td:eq(${k})`;
						if (j % 4 == 0 )  sumCell = `tr:eq(${2 + j}) th:eq(${k})`;
						$('#content-view3 div table').find(sumCell).text(arr[j * 3 + k].toFixed(2));
					}
				}
			}
		}
	},
	setLayout: function(data) {
		let rate = data.rate;
		let cell = data.cell;
		let sum = data.sum;
		let div = `<div>
			<table class="table table-bordered table-condensed table-hover">
				<thead>
					<tr class="info">
						<th colspan="3">${rate}</th>
					</tr>
					<tr class="success">
						<th>金额</th>
						<th>税额</th>
						<th>商品</th>
					</tr>
				</thead>
				<tbody>
					<tr id="f-all-${rate}">
						<th>${sum[0][0]}</th>
						<th>${sum[0][1]}</th>
						<th>${sum[0][2]}</th>
					</tr>
					<tr id="f-0-${rate}">
						<td>${cell[0][0][0]}</td>
						<td>${cell[0][0][1]}</td>
						<td>${cell[0][0][2]}</td>
					</tr>
					<tr id="f-1-${rate}">
						<td>${cell[0][1][0]}</td>
						<td>${cell[0][1][1]}</td>
						<td>${cell[0][1][2]}</td>
					</tr>
					<tr id="f-2-${rate}">
						<td>${cell[0][2][0]}</td>
						<td>${cell[0][2][1]}</td>
						<td>${cell[0][2][2]}</td>
					</tr>
					<tr id="z-all-${rate}">
						<th>${sum[1][0]}</th>
						<th>${sum[1][1]}</th>
						<th>${sum[1][2]}</th>
					</tr>
					<tr id="z-0-${rate}">
						<td>${cell[1][0][0]}</td>
						<td>${cell[1][0][1]}</td>
						<td>${cell[1][0][2]}</td>
					</tr>
					<tr id="z-1-${rate}">
						<td>${cell[1][1][0]}</td>
						<td>${cell[1][1][1]}</td>
						<td>${cell[1][1][2]}</td>
					</tr>
					<tr id="z-2-${rate}">
						<td>${cell[1][2][0]}</td>
						<td>${cell[1][2][1]}</td>
						<td>${cell[1][2][2]}</td>
					</tr>
				</tbody>
				<tfoot>
					<tr id="all-all-${rate}">
						<th>${sum[2][0]}</th>
						<th>${sum[2][1]}</th>
						<th>${sum[2][2]}</th>
					</tr>
				</tfoot>
			</table>
		</div>`;
		return div;
	},
	formatData: function() {
		let cell = $('#container th, #container td');
		cell.each(function(i) {
			let old = $(this).text();
			if (!isNaN(old)) $(this).text(publicFuc.formatData(old, 2))
		})
	},
	getZF_PriceAndTaxSum: function() {
		let price = [];
		let tax = [];
		let arr = [];
		let s = $('#content-view3 tbody th');
		for (let i = 0; i < s.length; i++) {
			price.push(publicFuc.stringToNum($(s[3 * i]).text()));
			tax.push(publicFuc.stringToNum($(s[3 * i + 1]).text()));
		}
		arr.push(price);
		arr.push(tax);
		return arr;
	},
	getZS_PriceAndTaxSum: function() {
		let price = [];
		let tax = [];
		let arr = [];
		let s = $('#content-view3 tbody tr');
		for (let i = 5; i < s.length; i++) {
			price.push(publicFuc.stringToNum($($(s[i]).find('td')[0]).text()));
			tax.push(publicFuc.stringToNum($($(s[i]).find('td')[1]).text()));
		}
		arr.push(price);
		arr.push(tax);
		return arr;
	}
};

var publicFuc = {
	stringToNum: function(strOrNum) {
		return Number(String(strOrNum).replace(/,/g, ''));
	},
	formatData: function setThousandsAndDecimal(num,count) {
		var num = this.stringToNum(num);
	    if (isNaN(num)) {
	        console.error('非法参数:' + num);
	        console.error('setThousandsAndDecimal()方法，第1个参数不能转化为数值型，请检查！');
	    }
	    if (isNaN(Number(count))) {
	    		count = 2;  
	    }
	    var str = num.toFixed(count); //先转为保留count位小数的字符串
	    var integerPart = parseInt(num); //整数部分
	    var decimalPart = str.substring(str.indexOf('.')) // 截取 .23
	    var returnData = '';
	    returnData = (integerPart || 0).toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,') + decimalPart;
	    if (num < 0.00 && (0 - num) < 1.00) {
	        returnData = '-' + returnData;
	    }
	    return returnData;
	},
	
}

window.outerFunction = function(arr) {
	console.log(arr);
}
init();
function init() {
	randomData.redrawCenterLayout();
	randomData.sumAll();
	randomData.formatData();
	chartOption.resetChart();
}




})