var canvas = document.getElementById('canvas');
var p = document.getElementsByTagName("p")[0];
var context = canvas.getContext('2d');
var cWidth = 400;
var cHeigth = 600;
var pipeDis = 150;
var birdImgs = ['images/0.gif', 'images/1.gif', 'images/2.gif'];
var birdIndex = 0;
var g = 10;
var isScore = false;
var score = 0;
var tid = null;
//基类
function Base(x, y, width, height, src) {
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;

	this.img = new Image();
	this.img.src = src;
}

//背景
function Background(x, y, width, height, src) {
	this.draw = drawBackground;
	Base.call(this, x, y, width, height, src);
}

function drawBackground() {
	context.drawImage(this.img, this.x, this.y, this.width, this.height);
}
//地面
function Ground(x, y, width, height, src) {
	this.draw = drawGround;
	Base.call(this, x, y, width, height, src);
}

function drawGround() {
	context.drawImage(this.img, this.x, this.y, this.width, this.height);
}
//管道
function Pipe(cutX, cutY, cutWidth, cutHeight, x, y, width, height, src) {
	this.cutX = cutX;
	this.cutY = cutY;
	this.cutWidth = cutWidth;
	this.cutHeight = cutHeight;
	this.draw = drawPipe;
	Base.call(this, x, y, width, height, src);
}

function drawPipe() {
	context.drawImage(this.img, this.cutX, this.cutY, this.cutWidth, this.cutHeight, this.x, this.y, this.width, this.height);
}

//小鸟

function Bird(x, y, width, height, src) {
	this.draw = birdDraw;
	Base.call(this, x, y, width, height, src);
}

function birdDraw() {
	birdIndex++;
	this.img.src = birdImgs[birdIndex % 3];
	context.drawImage(this.img, this.x, this.y, this.width, this.height);
}

var bg = new Background(0, 0, cWidth, cHeigth, "images/bg.png");
var ground = new Ground(0, 550, cWidth, 200, "images/ground.png");

var upPipe = new Pipe(160, 488, 130, 800, 0, 0, 100, 200, "images/pipe.png");
var downPipe = new Pipe(10, 478, 130, 800, 0, 350, 100, 200, "images/pipe.png");

var bird = new Bird(100, 250, 42, 32, 'images/0.gif');

var tid = setInterval(function() {
	panDuan();
	drawAll();
	caculator();
}, 60)

function drawAll() {
	bg.draw();
	ground.draw();
	upPipe.draw();
	downPipe.draw();
	bird.draw();
}

function caculator() {
	bird.y += g;
	if(upPipe.x <= -100) {
		upPipe.x = 400;
		downPipe.x = 400;
		upPipe.height = Math.random() * 300;
		downPipe.y = upPipe.height + 150;
		downPipe.height = 400 - upPipe.height;
		isScore = true;
	} else {
		upPipe.x -= 5;
		downPipe.x -= 5;
	}

	if(isScore && bird.x > (upPipe.x + upPipe.width)) {
		score++;
		// 关闭得分开关
		isScore = false;
	}

	context.fillStyle = "pink";
	context.strokeStyle = "lime";
	context.font = 'normal 20px Arial'
	context.strokeText('目前得分：' + score, 30, 30);
	context.fillText('历史最高：' + window.localStorage.getItem('ss'), 230, 30);
}

function panDuan() {
	var groundCondtion = (bird.y + bird.height) > 550;
	var pipeCondtion = ((bird.x + bird.width) > upPipe.x) && (bird.x < (upPipe.x + upPipe.width)) && ((bird.y < upPipe.height) || ((bird.y + bird.height) > downPipe.y));
	var pipeCondtion = ((bird.x + bird.width) > upPipe.x) && (bird.x < (upPipe.x + upPipe.width)) && ((bird.y < upPipe.height) || ((bird.y + bird.height) > downPipe.y));

	if(groundCondtion || pipeCondtion) {
		clearInterval(tid);
		var max = window.localStorage.getItem('ss');
		if(max) {
			if(score > max) {
				window.localStorage.setItem('ss', score);
			}
		} else {
			window.localStorage.setItem('ss', score);
		}
		p.innerHTML = "The Game is over";
	}
}

document.onkeydown = function(e) {
	var event = e || window.event;
	var codeValue = e.charCode || e.keyCode || e.which;
	if(codeValue == 32) {
		bird.y -= 70;
	}
}