﻿//
//jWin8metro
//
$.fn.jWin8metro = function (optionObj) {
    var container = this; //当容器
    var preOneS;//标识长按
    var metroActElem = optionObj.metroActElem;//磁帖动作容器元素
    var endfunc = optionObj.dragEnd; //拖拽结束想要触发的函数
    //重新初始化排序
    $.fn.initMetroPos(container);
    //初始个性色的磁帖
    $(container).children().children(":last-child").each(function () {//规定最后一个子节点设置颜色
        var $likeColor = $(this); //比方是设置颜色的隐藏域
        if ($likeColor.is(":hidden")) {
            var _name = $likeColor.attr("name"); //带方式的方法名
            var _value = $likeColor.attr("value"); //执行到的连接 
            if (!$likeColor.attr("name")) { //规定name属性为null，则为设置颜色
                $likeColor.parent().css({ "background-color": _value });
            }
        }
    });
    $(container).children().mousedown(function (e) {//按下鼠标
        var i = 0;
        var $this = $(this);
        preOneS = setInterval(function () {
            i += 0.5;
            if (i == 0.5) {
                window.hasLongPre = true;
                $.fn.longPreDone(e, $this);
            }
        }, 500);
    });
    $(container).children().mouseup(function () {//抬起鼠标
        var $this = $(this); //ul
        clearInterval(preOneS);
        if (!window.hasLongPre) {//短按
            //短按跳转连接
            var $clickObj = $this.children(":first-child").is("div") ? $this.children(":first-child").next() : $this.children(":last-child"); //紧接<div>的为磁帖功能设置元素?????????ok
            if ($clickObj.is("a")) {//连接
                window.location.href = $clickObj.attr("href");
            }
            else {//其他的单击
                $clickObj.click();
            }
        }
        else {//长按
            window.location.href = "#"; //禁止跳转
        }
    });
    //
    //longPreDone长按触发
    //
    $.fn.longPreDone = function (e, $this) { //长按触发
        if (e.which != 1 || $(e.target).is("input, textarea")) return; // 排除非左击和表单元素
        e.preventDefault(); // 阻止选中文本
        var x = e.pageX; //容器x坐标，浏览器
        var y = e.pageY; //容器y坐标
        var _this = $this; // 点击选中块
        var w = _this.width(); //磁帖宽度
        var h = _this.height(); //磁帖高度
        var w2 = w / 2; //磁帖半宽
        var h2 = h / 2; //磁帖半高
        var p = _this.offset(); //磁帖的top 和 left,相对容器
        var left = p.left; //磁帖的left
        var top = p.top; //磁帖的top
        // 添加虚线框
        _this.before('<div id="mr_holder"></div>'); //在每个匹配的元素之前插入内容
        var wid = $("#mr_holder"); //虚线框
        wid.css({ "margin": _this.css("margin-right"), "float": _this.css("float"), "width": w, "height": h });
        _this.css({ "float": _this.css("float"), "width": w, "height": h, "position": "absolute", "left": left, "top": top, "z-index": 999 });
        $(container).children().not(_this).not(wid).each(function () {////其他变浅
            var $obj = $(this);
            $obj.css({ opacity: 0.7 });
        });
        // 绑定mousemove事件
        $(document).mousemove(function (e) {
            e.preventDefault(); // 阻止选中文本
            // 移动选中块，距离文档的左边缘pageX
            var l = left + e.pageX - x; //原磁帖left+磁帖pageX-容器pageX,移动后的相对容器的距离
            var t = top + e.pageY - y; //移动后的相对容器的距离
            _this.css({ "left": l, "top": t }); //移动
            var ml = l + w2;//选中块的中心坐标
            var mt = t + h2;
            // 遍历所有块的坐标（除了当块和当的虚线框）
            $(container).children().not(_this).not(wid).each(function (i) {
                var obj = $(this); //其他块
                var p = obj.offset(); //块的相对坐标组
                var a1 = p.left; //块相对左
                var a2 = p.left + obj.width(); //块右下角相对左
                var a3 = p.top; //块相对上
                var a4 = p.top + obj.height(); //块右下角相对上
                // 移动虚线框
                if (a1 < ml && ml < a2 && a3 < mt && mt < a4) {//选中块在当块的内部时
                    if (!obj.next("#mr_holder").length) {//当块其后是虚线框的结果集的长度，即选中块在某块之后时
                        wid.insertAfter(this); //虚线框插入当块后
                    } else {
                        wid.insertBefore(this); //虚线框插入当块后
                    }
                    return;
                }
            });
        });

        // 绑定mouseup事件
        $(document).mouseup(function () {
            $(document).off('mouseup').off('mousemove'); //所有元素禁止鼠标抬起，移动事件
            //clearTimeout(preOneS); //清除计数器
            window.hasLongPre = false;
            // 检查当容器为空的情况,遍历所有容器
            $(container).each(function () {
                var obj = $(this).children(); //框框们
                var len = obj.length; //框框数
                if (len == 1 && obj.is(_this)) {//一个框框，并且是刚释放的，将要为空 
                    $("<div></div>").appendTo(this).attr("class", "wid_block").css({ "height": _this.height() }); //将空div追加到容器，并给div加样式
                } else if (len == 2 && obj.is(".wid_block")) {//两个框框，且含虚线框
                    $(this).children(".wid_block").remove(); //移除虚线框
                }
            });

            // 磁帖归位动画，并删除虚线框
            var p = wid.offset(); //获虚线框相对坐标
            _this.animate({ "left": p.left, "top": p.top }, 100, function () {
                _this.removeAttr("style"); //磁帖移除JQ动画产生的样式
                //检查并恢复用户色

                if (_this.children(":last-child").is(":hidden") && !_this.children(":last-child").attr("name")) {
                    var _value = _this.children(":last-child").attr("value");
                    _this.css({ "background-color": _value });
                }
                wid.replaceWith(_this); //磁帖替换虚线框
            });
            $(container).children().not(_this).not(wid).each(function () {///恢复磁帖
                var $obj = $(this);
                $obj.css({ opacity: 1 });
            });
            $.fn.recordMetroPos(wid.parent(), _this);//记录当前位置
            //执行拖动后触发的函数
            if (typeof (endfunc) == 'function') {
                endfunc(_this);
            }
        });
    };
    return $(this);
}
//
//触发上下滑动
//
$.fn.jMetroRun = function (firstDly, secondDly, metroHeight, firstSpeed, secondSpeed) {
    var container = this; //容器们
    $(container).children().children("div:first-child").children().each(function (i) {
        var $obj = $(this).parent(); //找到包含图片的空div
        $obj.css({ "position": "relative" });
        setInterval(function () {
            $obj.delay(firstDly);
            $obj.animate({ bottom: metroHeight }, firstSpeed, function () {
                $obj.delay(secondDly);
                $obj.animate({ bottom: "0px" }, secondSpeed);
            });
        }, 5000 + Math.random() * 5000);
    });
    return $(this);
};
//
//触发旋转
//
$.fn.jMetroTurn = function (metroHeight, firstSpeed, secondSpeed) {
    var container = this; //容器们
    $(container).children().each(function () {
        var $thisUl = $(this);//每个ul
        if ($thisUl.children(":first-child").is("img")) {//判断是否是旋转磁帖
            var ulLength = $thisUl.children().length;
            $thisUl.children().css({ "width": "0", "height": "0", "position": "relative" }); //所有设为0
            var imgSrcArr = []; //src数组
            var my$obj = $thisUl.children(":first").css({ "width": metroHeight, "height": metroHeight, "position": "relative" });
            $thisUl.children("img").each(function (i) {
                var $obj = $(this); //img
                imgSrcArr[i] = $obj.attr("src");
            });
            $thisUl.children("not:first").remove(); //删除首节点之后的节点
            var iCon = 0;
            setInterval(function () {
                my$obj.animate({ height: "0px", top: (metroHeight / 2), opacity: 0.2 }, firstSpeed, function () {//变小
                    if (my$obj.attr("src") == imgSrcArr[iCon]) {//不同则变
                        my$obj.attr("src", imgSrcArr[++iCon]); //设置
                        iCon = iCon == (ulLength - 1) ? 0 : iCon;
                    }
                    else {
                        my$obj.attr("src", imgSrcArr[iCon]); //设置
                    }
                    my$obj.animate({ height: metroHeight, top: "0px", "opacity": "1" }, secondSpeed); //变大

                });
            }, 5000 + Math.random() * 5000); //5-10秒不等
        }
    });
    return $(this);
};
//
//扩展方法
//
$.fn.extend({
    recordMetroPos: function (container, _this) {//完成最后磁帖替换占位div后触发
        var $corder = container.children(":hidden:first-child");//
        if ($corder.is(":hidden")) { //如果有第一个隐藏域
            var str = '';
            $(container).children(":not(:hidden)").not(_this).each(function (i) {
                var $obj = $(this);
                if (typeof ($obj.attr("id")) != "undefined" && $obj.attr("id")!=null) {//.not("#mr_holder")
                    if ($obj.attr("id") == "mr_holder" && typeof (_this.attr("id")) != "undefined") {
                        str+=_this.attr("id") + ",";
                    }
                    else if ($obj.attr("id") != "mr_holder") {
                        str+=$obj.attr("id") + ",";
                    }
                }
            });
            if(str[str.length - 1] == ','){
                str = str.substring(0, str.length - 1);
            }
            $corder.val(str);
            //alert($corder.val());//输出当前顺序
        }
    },
    initMetroPos: function (container) {//加载时触发，重新排序
        $(container).each(function () {
            var $corder = $(this).children(":hidden:first-child"); //找到排序信息,第一个隐藏域
            var tDomHtml = {}; //??
            if ($corder.length > 0 && $corder.val() != "") {
                var strs = ($corder.val()).split(","); //拆分出数组
                var counter = 0; //记录排序内容长度
                for (var i = 0; i < strs.length; i++) {
                    if (strs[i] != "") {
                        tDomHtml[i] = $("#" + strs[i]); //记忆该节点
                        counter++;
                    }
                }
                for (var i = counter - 1; i > -1; i--) { //重新排序
                    tDomHtml[i].insertAfter($corder); //记忆的节点插入1，2，3...
                }
            }
        });
    },
});