var keyCodes,                     //键位与键盘值对应关系         JSON
    keys,                         //键盘对应的音符              JSON
    reverse,                      //键位与键盘值反向对应关系     JSON
    allScore,                     //所有曲谱                   JSON
    allKeyNum,                    //曲谱键数占位               NUMBER|STRING
    scoreLength,                  //曲谱长度                   NUMBER|STRING
    pianoCodeLength = 500,        //琴码偏移位置设置            NUMBER
    corrections = 30,             //琴谱位置补正                NUMBER
    speedCorre;                   //速度补正                    NUMBER


$(function() {
    /**
     * 事件绑定
     */
    $(document).ready(function() {
        let backRandom = parseInt(Math.random()*(5 - 1 + 1) + 1).toString(), 
            backnow = 'url("./image/score_background_' + backRandom + '.jpg")';

        Waves.init();                                            
        Waves.attach('.btn');                                    //初始化波浪
        $('#score_back').css("background-image",backnow);        //随机更换背景
        noteInit();                                              //初始化琴键
        getScoreList();                                          //获取曲谱列表

        /**
         * 点击播放
         */
        $("#doplay").click(function() {playstart();})
        /**
         * 停止
         */
        $("#dostop").click(function() {playstop();})
        /**
         * 暂停
         */
        $('#dopause').click(function(){playpause();})
        /**
         * 继续播放
         */
        $("#docontinue").click(function() {playcontinue();})
        /**
         * 编曲按钮
         */
        $('#addscore').click(function(){layer.msg('编曲模式开发中...',{icon: 1})})
        /**
         * 自动演奏按钮
         */
        $('#autoplaybtn').click(function() {
            $('.splayers').css({"display":"inline"});
            $('.key-wrapper').hide();
            $(this).addClass('btn-active');
            $('#freeplaybtn').removeClass('btn-active');
            $('#trackdetail').show();
            $('#navi .trackhead').show();
            $('#piano_code').show();
            playstop();
            readScore();
        })
        /**
         * 自由演奏按钮
         */
        $('#freeplaybtn').click(function() {
            $('.splayers').hide();
            $('.key-wrapper').show();
            $(this).addClass('btn-active');
            $('#autoplaybtn').removeClass('btn-active');
            $('#trackdetail').hide();
            $('#navi .trackhead').hide();
            $('#piano_code').hide();
            playstop();
        })

        /**
         * 选择曲谱时触发事件
         */
        $("select[name='scores']").change(function() {readScore();})

    })

    /**
    * 监听键盘事件
    */
    $(window).keydown(function(event) {
        let nowKey = event.keyCode, keyObj = document.getElementById('code-' + keyCodes[nowKey]);

        if (keyCodes[nowKey] != undefined){
            if (keyObj.paused){//是否暂停
                keyObj.play();
            }else {
                //未暂停则设置一个定时删除的播放器
                let nowSrc = keyObj.getAttribute('src'),
                    nowId = 'code-' + randomStr(20),
                    tmpAudio = '<audio id="' + nowId + '" src="'+ nowSrc +'"></audio>';

                $('#audiocontent').append(tmpAudio);
                document.getElementById(nowId).play();
                setTimeout(function() {
                    $('#' + nowId).remove();
                },5000)
            }
        }
    })
})

/**
 * 初始化琴板
 */
function noteInit() {
    let tones = $("select[name='tones']").find('option:selected').val(), 
        musical = $("select[name='musicals']").find('option:selected').val(),
        audioContent = '';

    for (let i in keys){
        let fileName = '';

        fileName += tones + '$' + keys[i] + '$' + i + '.mp3';
        audioContent += '<audio id="code-'+ i +'" src="./notes/'+ musical + '/' + tones + '/' + fileName + '"></audio>';
    }

    $('#audiocontent').html(audioContent);
}

/**
 * 钩子 资源文件
 * @param {*} res 
 */
function hookScore(res) {
    allScore = res;
}
/**
 * 钩子 配置文件
 */
function hookConfig(res){
    keys = res['ke'];
    keyCodes = res['k'];
    reverse = res['reverse'];
}

/**
* 读取所有曲谱列表
*/
function getScoreList() {
    for (let i in allScore){
        $('#scoreslist select').append('<option name="'+ i + '" >'+ i +'</option>');
    }
}

/**
 * 播放器 用于播放曲谱
 * @param {} keynum 琴键键数
 */
function players(keynum) {
    let i = $("input[name='pauseflag']").val(), speed = $("input[name='speed']").val(), nowScore = allScore[$("select[name='scores']").find('option:selected').val()];

    time();
    function time() {
        if (i <= keynum && $("input[name='stopflag']").val() != '1') {
            let goPlay = [];
            for (let a in nowScore['detail']){
                if (nowScore['detail'][a][i] != '0' && nowScore['detail'][a][i] != undefined){
                    let spcr = nowScore['detail'][a][i].split('|'), tmpspcr, tmpspcrtime;

                    goPlay.push(reverse[spcr[0]]);

                    //分裂快速弹奏
                    if (spcr[1] != undefined){
                        tmpspcr = spcr[1].split(',');
                        tmpspcrtime = spcr[2].split(',');

                        for (let d in tmpspcr){
                            setTimeout(function(){
                                simulationKeydown(reverse[tmpspcr[d]]);
                            },tmpspcrtime[d]);
                        }
                    }
                }
            }

            //字符放大
            // $('.note').eq(i - 1).removeClass('noteactive');
            for (let t in nowScore['detail']){
                $('#trackdetail li').eq(t).find('.note').eq(i).addClass('noteactive');
            }

            $("input[name='pauseflag']").val(i);
            simulationKeydown(goPlay);//模拟按键
            i++;
            setTimeout(time, speed);
        } else if(i > keynum){
            // 曲谱播放完毕后
            playstop();
        } else {
            // 未达到条件
            return;
        }
    }
}
/**
 * 开始播放
 */
function playstart() {
    $('#doplay').hide();
    $('#dopause').show();
    $('#dostop').show();
    $("input[name='stopflag']").val('0');
    players(allKeyNum);//执行播放
    //让音轨动起来
    $('#trackdetail').animate(
        {'left':'-' + (scoreLength - pianoCodeLength + corrections).toString()}, 
        parseInt($("input[name='speed']").val()) * (parseInt(allKeyNum) + parseInt(speedCorre)),
        'linear'
    )
}
/**
 * 停止播放
 */
function playstop() {
    $('#doplay').show();
    $('#dopause').hide();
    $('#dostop').hide();
    $("#docontinue").hide();
    $("input[name='stopflag']").val('1');
    $("input[name='pauseflag']").val('0');//重置键位

    $('#trackdetail').stop();
    resetScore();
}
/**
 * 暂停播放
 */
function playpause() {
    $("#docontinue").css({'display':"inline"});
    $('#dopause').hide();
    $("input[name='stopflag']").val('1');

    $('#trackdetail').stop();
    $('#trackdetail').css({'left':'-' + $("input[name='pauseflag']").val() * 100 + pianoCodeLength});
}
/**
 * 继续播放
 */
function playcontinue() {
    $("#docontinue").hide();
    $('#dopause').css({'display':"inline"});
    $("input[name='stopflag']").val(0);
    players(allKeyNum);

    $('#trackdetail').animate(
        {'left':'-' + (scoreLength - pianoCodeLength + corrections).toString()}, 
        parseInt($("input[name='speed']").val()) * ((parseInt(allKeyNum) + parseInt(speedCorre)) - parseInt($("input[name='pauseflag']").val())),
        'linear'
    )
}
/**
 * 重置琴谱
 */
function resetScore() {
    $('#trackdetail').css({'left':pianoCodeLength});   //重置琴谱
    $('.note').removeClass('noteactive');              //重置琴谱状态
}

/**
 * 读取琴谱数据
 */
function readScore() {
    let n = allScore[$("select[name='scores']").find('option:selected').val()], trackhead = '', tracks = '';

    $('#author').html('曲谱翻译: <span style="color: #F90">' + n['author'] + '</span>');
    $("input[name='speed']").val(n['rate']);
    allKeyNum = n['detail'][0].length;
    scoreLength = allKeyNum * 100;
    speedCorre = n['speedCorre'];

    //接入音轨
    for (let a in n['detail']){
        trackhead += '<li><div><div>' + (parseInt(a) + 1).toString() + '号音轨</div></div></li>';
        tracks += '<li style="width:'+ scoreLength +'px">';
        for (let b in n['detail'][a]){
            let t = n['detail'][a][b].split('|');
            tracks += '<div class="note">'+ t[0] +'</div>';
        }
        tracks += '</li>';
    }

    $('#trackdetail ul').html(tracks);
    $('.trackhead').html(trackhead);
}

/**
 * 模拟按键
 * @param k 按下的按键对应的key值
 */
function simulationKeydown(k) {
    let e = jQuery.Event("keydown"), u = jQuery.Event("keyup"), tmp = [];

    if (typeof k == 'object'){
        //组合按键
        for (let i in k){
            e.keyCode = k[i];
            tmp.push(k[i]);

            $(window).trigger(e);//按键按下
        }
        setTimeout(function(){
            for (let a in tmp){
                u.keyCode = tmp[a];

               $(window).trigger(u);//按键弹起
            }
        },50);
    }else {
        //单按键
        e.keyCode = k;
        u.keyCode = k;

        $(window).trigger(e);//按键按下
        setTimeout(function(){
            $(window).trigger(u);//按键弹起
        },50);
    }
}
/**
 * 随机生成字符串
 * @param {*} len 
 */
function randomStr(len) {
    let str = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',result = '';

    for (let i = len; i > 0; --i){
        result += str[Math.floor(Math.random() * str.length)];
    }

    return new Date().getTime() + result;
}
