$(document).ready( function () {
    var col = 0;
    var colors = ['#ff708d','#598bff','#42aaff','#ffc94d','#2ce69b'];
    $('.bj').on('click', function(){
       $('.content').css({'background':colors[col]});
       if(col == 4){
           col = 0;
       }else{
           col++;
       }
       cnavasfun();
    });
    $(".pl").bind("input propertychange",function(event){
        setTimeout(function () {
            cnavasfun();
        },10);
    });
    $('.tj').on('click', function(){
        var pl = $('.pl').val();
        $('.pl').val('');
        $('.plq').append('<div>' + pl + '</div>');
        cnavasfun();
    });

    var h = $(window).height() - 5;
    var w = $(window).width();
    $("#box").append('<canvas id="canvas" width='+w+' height='+h+' style="display: none;"></canvas>');
    var img = document.getElementsByTagName('img')[0];
    var canvas=document.getElementById("canvas");
    var ctx = canvas.getContext("2d");
    var allChunks = [];
    var stream = canvas.captureStream(60); // 60 FPS recording   1秒60帧
    var recorder = new MediaRecorder(stream, {
        // videoBitsPerSecond: 250000,   // 设置视频的清晰度
        mimeType: 'video/webm;codecs=vp9'
    });
    recorder.ondataavailable = e => {  // 接收数据
        allChunks.push(
            e.data
        );
    };

    $('.startBtn').on('click', function(){    // 开始录制
        if (MediaRecorder.isTypeSupported('video/webm;codecs=vp9')) {
            cnavasfun();
            recorder.start(10);
        }
    });

    $('.pauseBtn').on('click', function(){    // 暂停录制
        recorder.pause();
    });

    $('.resumeBtn').on('click', function(){    // 继续录制
        recorder.resume();
    });

    $('.stopBtn').on('click', function(){    // 结束录制

        cnavasfun();
        setTimeout(function () {
            recorder.stop();
            var link = document.createElement('a');
            link.style.display = 'none';
            var fullBlob = new Blob(allChunks);
            var downloadUrl = window.URL.createObjectURL(fullBlob);
            link.href = downloadUrl;
            link.download = 'canvas-video.mp4';
            document.body.appendChild(link);
            link.click();
            link.remove();
        },1000);

    });

    function cnavasfun(){
        new html2canvas(document.getElementById('box')).then(canvas => {
            var imgStr = canvas.toDataURL("image/png");
            img.src = imgStr;
            img.onload = function() {
                ctx.drawImage(img,0,0,w,h);
            }
        });
    }
});